#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Blood TunnelMod01.fsh   by    AieKick
//https://www.shadertoy.com/view/Mtd3RS
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by Stephane Cuillerdier - Aiekick/2015 (twitter:@aiekick)
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
// Tuned via XShade (http://www.funparadigm.com/xshade/)

vec2 path(float t){	return vec2(cos(t*0.2), sin(t*0.2)) * 2.;}

vec2 df(vec3 p)
{
	p.xy -= path(p.z);
	float hex = (max(abs(p.x) + p.y, -p.y) + max(abs(p.x) - p.y, p.y));
	float tex = texture2D(iChannel0, (abs(p.xz) + abs(p.yz))*0.28).r * atan(p.x,p.y)/3.14159 * 1.;
	p*=3.;
	float maze = cos(3.14 * (p.x + p.y * sign(sin(1e3 * length(floor(p.xy))))));
	return vec2(0.8 * hex - maze * 0.12 + tex - 4.8 , 2.);
}

vec3 nor( in vec3 pos, float prec )
{
	vec3 eps = vec3( prec, 0., 0. );
	vec3 nor = vec3(
	    df(pos+eps.xyy).x - df(pos-eps.xyy).x,
	    df(pos+eps.yxy).x - df(pos-eps.yxy).x,
	    df(pos+eps.yyx).x - df(pos-eps.yyx).x );
	return normalize(nor);
}

// return color from temperature 
//http://www.physics.sfasu.edu/astro/color/blackbody.html
//http://www.vendian.org/mncharity/dir3/blackbody/
//http://www.vendian.org/mncharity/dir3/blackbody/UnstableURLs/bbr_color.html
vec3 blackbody(float Temp)
{
	vec3 col = vec3(255.);
    col.x = 56100000. * pow(Temp,(-3. / 2.)) + 148.;
   	col.y = 100.04 * log(Temp) - 623.6;
   	if (Temp > 6500.) col.y = 35200000. * pow(Temp,(-3. / 2.)) + 184.;
   	col.z = 194.18 * log(Temp) - 1448.6;
   	col = clamp(col, 0., 255.)/255.;
    if (Temp < 1000.) col *= Temp/1000.;
   	return col;
}

// get density of the df at surfPoint
// ratio between constant step and df value
float SubDensity(vec3 surfPoint, float prec, float ms) 
{
	vec3 n = vec3(0);
	float s = 0.;
    const int iter = 10;
	for (int i=0;i<iter;i++)
	{
		n = nor(surfPoint,prec); 
		surfPoint = surfPoint - n * ms; 
		s += df(surfPoint).x;
	}
	return 1.-s/(ms*float(iter)); // s < 0. => inside df
}

float SubDensity(vec3 p, float s) 
{
	vec3 n = nor(p,s); 							// precise normale at surf point
	return df(p - n * s).x;						// ratio between df step and constant step
}

// from shane sahders
// Tri-Planar blending function. Based on an old Nvidia writeup:
// GPU Gems 3 - Ryan Geiss: http://http.developer.nvidia.com/GPUGems3/gpugems3_ch01.html
vec3 tex3D( sampler2D tex, in vec3 p, in vec3 n )
{
    n = max((abs(n) - .2)*7., .001);
    n /= (n.x + n.y + n.z );  
	p = (texture2D(tex, p.yz)*n.x + texture2D(tex, p.zx)*n.y + texture2D(tex, p.xy)*n.z).xyz;
    return p*p;
}

vec4 shade(vec3 ro, vec3 rd, float d, vec3 lp, float li)
{
	vec3 p = ro + rd * d;											// surface point
	float sb = SubDensity(p, 0.01, 0.076);							// deep subdensity (10 iterations)
	vec3 bb = blackbody(40.*sb+0.);								// bb
	vec3 ld = normalize(lp-p); 										// light dir
	vec3 n = nor(p, 0.08);	// normal at surface point
    
    // derived from bumpmap func from shane
    const vec2 e = vec2(0.1, 0);
    mat3 m = mat3( tex3D(iChannel0, e.xyy, n), tex3D(iChannel0, e.yxy, n), tex3D(iChannel0, e.yyx, n));
   	vec3 g = vec3(1,0,0) * m * 20.;
    g -= n * dot(n, g);
    n =  normalize( n + g );
    
	vec3 refl = reflect(rd,n);										// reflected ray dir at surf point 
	float amb = 0.1242; 											// ambiance factor
	float diff = clamp( dot( n, ld ), 0, 1.0 ); 					// diffuse
	float fre = pow( clamp( 1. + dot(n,rd),0.0,1.0), 4. ); 			// fresnel
	float spe = pow(clamp( dot( refl, ld ), 0.0, 1.0 ),16.);		// specular
	float sss = 1. - SubDensity(p, 7.8); 							// one step sub density of df
	return vec4(
        (diff + fre + bb.x * sss) * amb * li + spe, 
        (diff + fre + bb * sb * 0.608 + sss * 0.352) * amb * li + spe * 0.612 	
    );
}

vec3 cam(vec2 uv, vec3 ro, vec3 cv, float t)
{
	vec3 cu = normalize(vec3(0,1,0));
  	vec3 z = normalize(cv-ro);
    vec3 x = normalize(cross(cu,z));
  	vec3 y = cross(z,x);
  	return normalize(z + uv.x*x + uv.y*y);
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    float t = -iTime*3.;

    vec2 si = iResolution.xy;
    vec2 g = fragCoord;
    
    vec2 uv = (g+g-si)/si.y;
    
    vec3 col = vec3(0.);
    
	vec3 ro = vec3(path(t),t);
  	vec3 cv = vec3(path(t),t+.1);
	vec3 rd = cam(uv, ro, cv, t);
       
	float md = 20.,s = 1.,d = 0.;
	
	const float iter = 250.;
    for(float i=0.;i<iter;i++)
    {      
        if (s<.025*log(d*d/s/500.)||d>md) break;
        s = df(ro+rd*d).x;
		d += s * 0.3;
    }
    
    if (iMouse.z > 0.)
        if (iMouse.x < si.x * 0.5)
			d = min(d,d*d*d/md); // weird but cool also
       	else
    		d = min(d*.6,d*d*d/md); // another flame version
    
    fragColor.rgb = mix(
        shade(ro, rd, d, ro, 1.2).yzw, 
        vec3(.2,0,0), 
        1.-exp(-0.01*d*d)
    );
    
    fragColor.a = 1;
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

